package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class RecommendedCostTable(name: String = "recommended_cost", alias: String? = null) : TableWithIndexes(name, alias) {
    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val CATEGORY = Column<String>(this, "category", PrimitiveType.utf8())
    val PLATFORM = Column<Int>(this, "platform", PrimitiveType.uint32())
    val TYPE = Column<Int>(this, "type", PrimitiveType.uint32())
    val RECOMMENDED_COST = Column<Long>(this, "recommended_cost", PrimitiveType.uint64())

    private val COLUMNS = listOf(
        ID,
        CATEGORY,
        PLATFORM,
        TYPE,
        RECOMMENDED_COST,
    )

    val RECOMMENDED_COST_CATEGORY_INDEX = Index(this, CATEGORY, "category")

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(RECOMMENDED_COST_CATEGORY_INDEX)
    override fun getInstance(realName: String, alias: String?) = RecommendedCostTable(realName, alias)
}
