package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class RejectReasonsTable(name: String = "reject_reasons", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val DIAG_ID = Column<Int>(this, "diag_id", PrimitiveType.uint32())
    val TITLE = Column<String?>(this, "title", PrimitiveType.utf8())
    val DESCRIPTION = Column<String?>(this, "description", PrimitiveType.utf8())
    val LANG = Column<String?>(this, "lang", PrimitiveType.utf8())

    private val COLUMNS = listOf(
            ID,
            DIAG_ID,
            TITLE,
            DESCRIPTION,
            LANG,
    )
    val DIAG_ID_INDEX = Index(this, DIAG_ID, "diag_id")

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(DIAG_ID_INDEX)
    override fun getInstance(realName: String, alias: String?) = RejectReasonsTable(realName, alias)
}
