package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class TrackerUrlStatTable(
    name: String = "tracker_url_stat", alias: String? = null
) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val TRACKER_URL = Column<String>(this, "tracker_url", PrimitiveType.utf8())
    val UPDATE_TIME = Column<Long>(this, "update_time", PrimitiveType.int64())
    val COUNTER_TYPE = Column<Long>(this, "counter_type", PrimitiveType.uint64())
    val HIT_COUNT = Column<Long>(this, "hit_count", PrimitiveType.uint64())

    val ACHIEVED_LEVEL = Column<Long>(this, "achieved_level", PrimitiveType.uint64())
    val ADDED_PAYMENT_INFO = Column<Long>(this, "added_payment_info", PrimitiveType.uint64())
    val ADDED_TO_CART = Column<Long>(this, "added_to_cart", PrimitiveType.uint64())
    val ADDED_TO_WISHLIST = Column<Long>(this, "added_to_wishlist", PrimitiveType.uint64())
    val APP_LAUNCHED = Column<Long>(this, "app_launched", PrimitiveType.uint64())
    val COMPLETED_REGISTRATION = Column<Long>(this, "completed_registration", PrimitiveType.uint64())
    val COMPLETED_TUTORIAL = Column<Long>(this, "completed_tutorial", PrimitiveType.uint64())
    val CUSTOM_EVENT = Column<Long>(this, "custom_event", PrimitiveType.uint64())
    val EVENT_1 = Column<Long>(this, "event_1", PrimitiveType.uint64())
    val EVENT_2 = Column<Long>(this, "event_2", PrimitiveType.uint64())
    val EVENT_3 = Column<Long>(this, "event_3", PrimitiveType.uint64())
    val INITIATED_CHECKOUT = Column<Long>(this, "initiated_checkout", PrimitiveType.uint64())
    val INSTALLS = Column<Long>(this, "installs", PrimitiveType.uint64())
    val PURCHASED = Column<Long>(this, "purchased", PrimitiveType.uint64())
    val RATED = Column<Long>(this, "rated", PrimitiveType.uint64())
    val REMOVED_FROM_CART = Column<Long>(this, "removed_from_cart", PrimitiveType.uint64())
    val SEARCHED = Column<Long>(this, "searched", PrimitiveType.uint64())
    val SHARED = Column<Long>(this, "shared", PrimitiveType.uint64())
    val SPENT_CREDITS = Column<Long>(this, "spent_credits", PrimitiveType.uint64())
    val SPENT_TIME_IN_APP = Column<Long>(this, "spent_time_in_app", PrimitiveType.uint64())
    val UNLOCKED_ACHIEVEMENT = Column<Long>(this, "unlocked_achievement", PrimitiveType.uint64())
    val VIEWED_CONTENT = Column<Long>(this, "viewed_content", PrimitiveType.uint64())

    val TRACKER_URL_UPDATE_TIME_INDEX = Index(
        this, listOf(TRACKER_URL, UPDATE_TIME), "tracker_url__update_time"
    )
    val TRACKER_EVENT_COLUMNS = listOf(
        ACHIEVED_LEVEL,
        ADDED_PAYMENT_INFO,
        ADDED_TO_CART,
        ADDED_TO_WISHLIST,
        APP_LAUNCHED,
        COMPLETED_REGISTRATION,
        COMPLETED_TUTORIAL,
        CUSTOM_EVENT,
        EVENT_1,
        EVENT_2,
        EVENT_3,
        INITIATED_CHECKOUT,
        INSTALLS,
        PURCHASED,
        RATED,
        REMOVED_FROM_CART,
        SEARCHED,
        SHARED,
        SPENT_CREDITS,
        SPENT_TIME_IN_APP,
        UNLOCKED_ACHIEVEMENT,
        VIEWED_CONTENT
    )
    private val COLUMNS = listOf(
        ID,
        TRACKER_URL,
        UPDATE_TIME,
        COUNTER_TYPE,
        HIT_COUNT,
    ) + TRACKER_EVENT_COLUMNS

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(TRACKER_URL_UPDATE_TIME_INDEX)
    override fun getInstance(realName: String, alias: String?) = TrackerUrlStatTable(realName, alias)
}
