package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.Table
import ru.yandex.direct.ydb.table.TableWithIndexes

class UserTable(name: String = "user", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val UID = Column<Long>(this, "uid", PrimitiveType.uint64())
    val CREATED_AT = Column<Long>(this, "created_at", PrimitiveType.uint64())

    val UID_INDEX = Index(this, UID, "uid")
    private val COLUMNS = listOf(
        ID,
        UID,
        CREATED_AT
    )

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(UID_INDEX)
    override fun getInstance(realName: String, alias: String?) = UserTable(realName, alias)
}
