package ru.yandex.direct.core.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.core.grut.api.AdGroupBriefGrutModel
import ru.yandex.direct.core.grut.replication.GrutApiService

@Service
class AdGroupBriefService(
    private val grutApiService: GrutApiService,
    private val grutUacCampaignService: GrutUacCampaignService,
) {
    fun updateAdGroupBriefsRetargetingCondition(
        clientId: String,
        retargetingCondition: UacRetargetingCondition,
    ): List<AdGroupBriefGrutModel> {
        checkNotNull(retargetingCondition.id) {
            "Retargeting condition doesn't exist"
        }
        val adGroupBriefs = getAdGroupBriefsWithRetargetingCondition(clientId, retargetingCondition.id)
        if (adGroupBriefs.isEmpty()) return listOf()

        val updatedAdGroupBriefs = adGroupBriefs.map {
            it.copy(retargetingCondition = retargetingCondition)
        }
        grutApiService.adGroupBriefGrutApi.updateRetargetingConditions(updatedAdGroupBriefs)
        return updatedAdGroupBriefs
    }

    fun getAdGroupBriefsWithRetargetingCondition(
        clientId: String,
        retargetingConditionId: Long,
    ): List<AdGroupBriefGrutModel> {
        val campaignIds = grutUacCampaignService.getCampaignIdsByClientId(clientId)
        return grutApiService.adGroupBriefGrutApi.selectAdGroupBriefs(
            filter = "[/meta/campaign_id] IN (${campaignIds.joinToString { "$it" }})" +
                " AND [/spec/retargeting_condition/id] = $retargetingConditionId",
        )
    }
}
