package ru.yandex.direct.core.entity.uac.service

import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbCampaignRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.core.grut.replication.GrutApiService
import ru.yandex.grut.objects.proto.client.Schema
import java.time.Instant

abstract class BaseUacBannerService {
    abstract fun updateBriefSynced(campaignId: String, briefSynced: Boolean)
}

@Lazy
@Component
class YdbUacBannerService(private val uacYdbCampaignRepository: UacYdbCampaignRepository)
    : BaseUacBannerService() {
    override fun updateBriefSynced(campaignId: String, briefSynced: Boolean) {
        uacYdbCampaignRepository.updateBriefSynced(campaignId, briefSynced)
    }
}

@Lazy
@Component
class GrutUacBannerService(
    private val grutApiService: GrutApiService,
) : BaseUacBannerService() {

    override fun updateBriefSynced(campaignId: String, briefSynced: Boolean) {
        grutApiService.briefGrutApi.updateBrief(
            Schema.TCampaign.newBuilder().apply {
                metaBuilder.apply {
                    id = campaignId.toIdLong()
                }
                specBuilder.apply {
                    updateTime = Instant.now().epochSecond.toInt()
                    campaignBriefBuilder.apply {
                        this.briefSynced = briefSynced
                    }
                }
            }.build(),
            setPaths = listOf("/spec/update_time", "/spec/campaign_brief/brief_synced"),
        )
    }
}
