package ru.yandex.direct.core.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository
import ru.yandex.direct.core.entity.campaign.service.CampaignService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper

@Service
class EcomUcCampaignService(
        private val campaignService: CampaignService,
        private val adGroupService: AdGroupService,
        private val campaignTypedRepository: CampaignTypedRepository,
        private val shardHelper: ShardHelper) {

    fun getSubCampaigns(clientId: ClientId, masterCids: List<Long>): List<CommonCampaign> {
        val shard = shardHelper.getShardByClientId(clientId)
        val subCampaigns = campaignService.getSubCampaignIdsWithMasterIds(masterCids, clientId)
        val campaigns = campaignTypedRepository.getTypedCampaigns(shard, subCampaigns.keys)
        return campaigns.filterIsInstance<CommonCampaign>()
    }

    fun getAdGroupIdsByCampaignIds(campaignIds: Set<Long>): Map<Long, List<Long>> {
        return adGroupService.getAdGroupIdsByCampaignIds(campaignIds)
    }

    fun getAdGroupsByCampaignIds(clientId: ClientId, campaignIds: Set<Long>): Map<Long, List<AdGroup>> {
        val adGroupIds = adGroupService
            .getAdGroupIdsByCampaignIds(campaignIds)
            .values
            .flatten()
        return adGroupService.getAdGroups(clientId, adGroupIds)
            .groupBy { it.campaignId }
    }

}
