package ru.yandex.direct.core.entity.uac.service

import kotlin.reflect.KProperty1
import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toCampaignSpec
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.replication.GrutApiService
import ru.yandex.direct.model.KtModelChanges
import ru.yandex.grut.objects.proto.client.Schema
import ru.yandex.grut.objects.proto.client.Schema.TCampaignMeta

@Service
@Lazy
class GrutUacCampaignUpdateService(
    private val grutApiService: GrutApiService,
) : BaseUacCampaignUpdateService() {

    override fun updateCampaignFromModelChanges(ydbCampaign: UacYdbCampaign, changes: KtModelChanges<String, UacYdbCampaign>) {
        fun <V> get(prop: KProperty1<UacYdbCampaign, V>): V =
            if (changes.isPresent(prop)) changes.getVal(prop) else prop.get(ydbCampaign)

        val ydbCampaignCopy = ydbCampaign.copy(
            updatedAt = get(UacYdbCampaign::updatedAt),
            createdAt = get(UacYdbCampaign::createdAt),
            startedAt = get(UacYdbCampaign::startedAt),
            name = get(UacYdbCampaign::name),
            storeUrl = get(UacYdbCampaign::storeUrl),
            zenPublisherId = get(UacYdbCampaign::zenPublisherId),
            appId = get(UacYdbCampaign::appId),
            regions = get(UacYdbCampaign::regions),
            trackingUrl = get(UacYdbCampaign::trackingUrl),
            impressionUrl = get(UacYdbCampaign::impressionUrl),
            targetId = get(UacYdbCampaign::targetId),
            cpa = get(UacYdbCampaign::cpa),
            weekLimit = get(UacYdbCampaign::weekLimit),
            targetStatus = get(UacYdbCampaign::targetStatus),
            options = get(UacYdbCampaign::options),
            skadNetworkEnabled = get(UacYdbCampaign::skadNetworkEnabled),
            adultContentEnabled = get(UacYdbCampaign::adultContentEnabled),
            directCampaignStatus = get(UacYdbCampaign::directCampaignStatus),
            briefSynced = get(UacYdbCampaign::briefSynced),
            keywords = get(UacYdbCampaign::keywords),
            minusKeywords = get(UacYdbCampaign::minusKeywords),
        )

        grutApiService.briefGrutApi.updateBriefFull(Schema.TCampaign.newBuilder().apply {
            meta = TCampaignMeta.newBuilder().setId(ydbCampaign.id.toIdLong()).build()
            spec = toCampaignSpec(ydbCampaignCopy)
        }.build())
    }
}
