package ru.yandex.direct.core.entity.uac.service

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate

fun toModerationState(status: CampaignStatusModerate?): ModerationState? {
    return when (status) {
        CampaignStatusModerate.YES -> ModerationState.ACCEPTED
        CampaignStatusModerate.NO -> ModerationState.REJECTED
        CampaignStatusModerate.NEW -> ModerationState.DRAFT
        CampaignStatusModerate.SENT -> ModerationState.MODERATION
        else -> null
    }
}

fun toCampaignState(status: GdSelfStatusEnum?): CampaignState? {
    return when (status) {
        null -> null
        GdSelfStatusEnum.RUN_OK -> CampaignState.ON
        GdSelfStatusEnum.RUN_PROCESSING -> CampaignState.ON
        GdSelfStatusEnum.RUN_WARN -> CampaignState.RUN_WARN
        GdSelfStatusEnum.STOP_OK -> CampaignState.OFF
        GdSelfStatusEnum.STOP_PROCESSING -> CampaignState.OFF
        GdSelfStatusEnum.STOP_WARN -> CampaignState.STOP_WARN
        GdSelfStatusEnum.STOP_CRIT -> CampaignState.STOP_CRIT
        GdSelfStatusEnum.PAUSE_OK -> CampaignState.SUSPENDED
        GdSelfStatusEnum.PAUSE_WARN -> CampaignState.PAUSE_WARN
        GdSelfStatusEnum.PAUSE_CRIT -> CampaignState.PAUSE_CRIT
        GdSelfStatusEnum.ARCHIVED -> CampaignState.ARCHIVED
        GdSelfStatusEnum.DRAFT -> CampaignState.DRAFT
        GdSelfStatusEnum.ON_MODERATION -> CampaignState.MODERATION
        else -> CampaignState.DRAFT
    }
}
