package ru.yandex.direct.core.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate
import ru.yandex.direct.core.entity.banner.model.old.StatusSitelinksModerate
import ru.yandex.direct.core.entity.uac.model.direct_ad.BannerModerationSubject
import ru.yandex.grut.objects.proto.AssetLink.TAssetLinkStatus.EAssetLinkStatus
import ru.yandex.grut.objects.proto.MediaType.EMediaType

@Service
class UacCampaignContentService {

    companion object {
        val BANNER_MODERATION_SUBJECT_BY_GRUT_MEDIA_TYPE = mapOf(
            EMediaType.MT_IMAGE to BannerModerationSubject.IMAGE,
            EMediaType.MT_VIDEO to BannerModerationSubject.CREATIVE,
            EMediaType.MT_TEXT to BannerModerationSubject.TEXT,
            EMediaType.MT_TITLE to BannerModerationSubject.TEXT,
            EMediaType.MT_HTML5 to BannerModerationSubject.CREATIVE,
            EMediaType.MT_SITELINK to BannerModerationSubject.SITELINKS_SET
        )
    }

    fun toBannerStatus(status: BannerStatusModerate?): EAssetLinkStatus {
        return when (status) {
            BannerStatusModerate.YES -> EAssetLinkStatus.ALS_ACTIVE
            BannerStatusModerate.NO -> EAssetLinkStatus.ALS_REJECTED
            BannerStatusModerate.SENT -> EAssetLinkStatus.ALS_MODERATING
            else -> EAssetLinkStatus.ALS_CREATED
        }
    }

    fun toBannerImageStatus(status: StatusBannerImageModerate?): EAssetLinkStatus {
        return when (status) {
            StatusBannerImageModerate.YES -> EAssetLinkStatus.ALS_ACTIVE
            StatusBannerImageModerate.NO -> EAssetLinkStatus.ALS_REJECTED
            StatusBannerImageModerate.SENT, StatusBannerImageModerate.SENDING -> EAssetLinkStatus.ALS_MODERATING
            else -> EAssetLinkStatus.ALS_CREATED
        }
    }

    fun toBannerCreativeStatus(status: BannerCreativeStatusModerate?): EAssetLinkStatus {
        return when (status) {
            BannerCreativeStatusModerate.YES -> EAssetLinkStatus.ALS_ACTIVE
            BannerCreativeStatusModerate.NO -> EAssetLinkStatus.ALS_REJECTED
            BannerCreativeStatusModerate.SENT, BannerCreativeStatusModerate.SENDING -> EAssetLinkStatus.ALS_MODERATING
            else -> EAssetLinkStatus.ALS_CREATED
        }
    }

    fun toBannerCreativeStatus(status: StatusSitelinksModerate?): EAssetLinkStatus {
        return when (status) {
            StatusSitelinksModerate.YES -> EAssetLinkStatus.ALS_ACTIVE
            StatusSitelinksModerate.NO -> EAssetLinkStatus.ALS_REJECTED
            StatusSitelinksModerate.SENT, StatusSitelinksModerate.SENDING -> EAssetLinkStatus.ALS_MODERATING
            else -> EAssetLinkStatus.ALS_CREATED
        }
    }
}


