package ru.yandex.direct.core.entity.uac.service

import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.dbutil.model.ClientId

@Lazy
@Component
class UacCampaignServiceHolder(
    private val uacDbDefineService: UacDbDefineService,
    private val ydbUacCampaignService: UacCampaignService,
    private val grutUacCampaignService: GrutUacCampaignService,
    private val ydbUacContentService: UacContentService,
    private val grutUacContentService: GrutUacContentService,
    private val ydbUacCampaignUpdateService: YdbUacCampaignUpdateService,
    private val grutUacCampaignUpdateService: GrutUacCampaignUpdateService,
    private val grutUacBannerService: GrutUacBannerService,
    private val ydbUacBannerService: YdbUacBannerService
) {

    fun getUacCampaignService(campaignId: String) =
        getUacCampaignService(uacDbDefineService.useGrut(campaignId))

    fun getUacCampaignService(clientId: ClientId, advType: AdvType) =
        getUacCampaignService(uacDbDefineService.useGrutForNewCampaign(clientId, advType))

    fun getUacCampaignService(useGrut: Boolean) =
        if (useGrut) grutUacCampaignService
        else ydbUacCampaignService

    // только для ручки /campaign/direct
    fun getUacCampaignServiceForDirectCampaignId(directCampaignId: Long) =
        if (uacDbDefineService.useGrutForDirectCampaignId(directCampaignId)) grutUacCampaignService
        else ydbUacCampaignService

    fun getUacCampaignUpdateService(campaignId: String) =
        getUacCampaignUpdateService(uacDbDefineService.useGrut(campaignId))

    fun getUacBannerService(campaignId: String) =
        getUacBannerService(uacDbDefineService.useGrut(campaignId))


    //если есть кампания с данным directCampaignId, выполняет действия над соответствующей ей заявкой
    fun <T> performUpdateActionOnCampaignUsingDirectId(
        directCampaignId: Long,
        updateAction: (BaseUacCampaignUpdateService, UacYdbCampaign) -> T
    ): T? {
        //TODO соптимизировать, чтобы не получать id по directCampaignId
        // внутри useGrutForDirectCampaignId и внутри getCampaignByDirectCampaignId
        val useGrut = uacDbDefineService.useGrutForDirectCampaignId(directCampaignId)
        return getUacCampaignService(useGrut)
            .getCampaignByDirectCampaignId(directCampaignId)
            ?.let { updateAction.invoke(getUacCampaignUpdateService(useGrut), it) }
    }

    fun getUacCampaignUpdateService(useGrut: Boolean) =
        if (useGrut) grutUacCampaignUpdateService
        else ydbUacCampaignUpdateService

    fun getUacContentService(campaignId: String) =
        getUacContentService(uacDbDefineService.useGrut(campaignId))

    fun getUacContentService(useGrut: Boolean) =
        if (useGrut) grutUacContentService
        else ydbUacContentService

    fun getUacBannerService(useGrut: Boolean) =
        if (useGrut) grutUacBannerService
        else ydbUacBannerService

}
