package ru.yandex.direct.core.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper
import kotlin.reflect.KClass
import kotlin.reflect.full.isSubclassOf

@Service
class UacCampaignsCoreService(
    val shardHelper: ShardHelper,
    val campaignTypedRepository: CampaignTypedRepository
) {
    fun <T : Any> getCampaign(clientId: ClientId, campaignId: Long, campaignType: KClass<T>): T? {
        val shard = shardHelper.getShardByClientId(clientId)
        return getCampaign(shard, campaignId, campaignType)
    }

    @Suppress("UNCHECKED_CAST")
    fun <T : Any> getCampaign(shard: Int, campaignId: Long, campaignType: KClass<T>): T? {
        val campaigns = campaignTypedRepository.getTypedCampaigns(
            shard,
            listOf(campaignId)
        )

        if (campaigns.isEmpty()) {
            return null
        }

        val campaign = campaigns[0]
        return if (campaign::class.isSubclassOf(campaignType)) {
            campaign as T
        } else {
            null
        }
    }
}
