package ru.yandex.direct.core.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.CampaignUtils
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository

@Service
class UacDisabledDomainsService(
    private val sspPlatformsRepository: SspPlatformsRepository,
) {
    fun getDisabledDomains(disabledPlaces: List<String>): List<String> {
        var disabledDomains: List<String> = listOf()
        if (disabledPlaces.isNotEmpty()) {
            val knownSsp: List<String> = sspPlatformsRepository.allSspPlatforms
            disabledDomains = CampaignUtils.getDisabledDomains(knownSsp, disabledPlaces)
        }
        return disabledDomains
    }
}
