package ru.yandex.direct.core.entity.uac.service.appinfo

import com.google.protobuf.util.JsonFormat
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.model.MobileAppStoreUrlWithOriginal
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.Store
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbAppInfo
import ru.yandex.direct.core.entity.uac.service.appinfo.ParseAppStoreContentService.ParseAppStoreContentException


@Service
class GooglePlayContentProcessor(
    private val parseAppStoreContentService: ParseAppStoreContentService
) {
    fun getAppInfoModel(urls: MobileAppStoreUrlWithOriginal): UacYdbAppInfo {
        val parsedContent = parseAppStoreContentService.parseAppStoreContent(urls)
        if (!parsedContent.hasGooglePlay()) {
            throw ProcessGooglePlayContentException("Parser returned empty google_play result for $urls.originalUrl")
        }

        return UacYdbAppInfo(
            appId = urls.parsedUrl.storeContentId,
            bundleId = urls.parsedUrl.storeContentId,
            language = urls.parsedUrl.storeLanguage.lowercase(),
            region = urls.parsedUrl.storeCountry.lowercase(),
            platform = Platform.ANDROID,
            source = Store.GOOGLE_PLAY,
            data = JsonFormat.printer().print(parsedContent.googlePlay)
        )
    }

    class ProcessGooglePlayContentException(message: String?) : ParseAppStoreContentException(message)
}

