package ru.yandex.direct.core.entity.uac.service.shopinshop

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.model.ShopInShopBusinessInfo
import ru.yandex.direct.core.entity.uac.repository.mysql.ShopInShopBusinessesRepository
import ru.yandex.direct.utils.model.UrlParts

@Service
class ShopInShopBusinessesService(
    private val shopInShopBusinessesRepository: ShopInShopBusinessesRepository
) {
    private val urlResolvers: List<ShopInShopUrlResolver> = listOf(
        MarketUrlResolver()
    )

    fun getBusinessInfoByUrl(url: String): ShopInShopBusinessInfo? {
        val urlParts = try {
            UrlParts.fromUrl(url)
        } catch (e: IllegalArgumentException) {
            return null
        }

        val urlResolver = urlResolvers
            .find { it.isApplicableByUrl(urlParts) }
            ?: return null

        val businessId = urlResolver.getBusinessIdFromUrl(urlParts)
            ?: return null

        val source = urlResolver.source
        val shopInShopBusiness = shopInShopBusinessesRepository.getBySourceAndBusinessId(source, businessId)
            ?: return null

        val isAdditionalCommission = urlResolver.isAdditionalCommission(urlParts)

        val urlWithoutCommission = urlResolver.getUrlWithoutCommission(urlParts, businessId)
        val urlToShopInShopAccount = urlResolver.getUrlToShopInShopAccount(urlParts, businessId)

        return ShopInShopBusinessInfo(
            businessId, shopInShopBusiness.feedUrl, shopInShopBusiness.counterId, source, urlResolver.targetDomain,
            isAdditionalCommission, urlWithoutCommission, urlToShopInShopAccount
        )
    }
}
