package ru.yandex.direct.core.entity.uac.service.shopinshop

import ru.yandex.direct.core.entity.uac.model.Source
import ru.yandex.direct.utils.model.UrlParts

interface ShopInShopUrlResolver {
    val source: Source

    val targetDomain: String

    fun isApplicableByUrl(url: UrlParts): Boolean

    fun getBusinessIdFromUrl(url: UrlParts): Long?

    /**
     * Обложение дополнительной комиссией маркетплейса
     */
    fun isAdditionalCommission(url: UrlParts): Boolean = false

    fun getUrlWithoutCommission(url: UrlParts, businessId: Long): String? = null

    fun getUrlToShopInShopAccount(url: UrlParts, businessId: Long): String? = null
}
