package ru.yandex.direct.core.entity.uac.service.trackingurl

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem
import ru.yandex.direct.utils.model.UrlParts

abstract class AppMetricaUrlParserBase(type: ParserType) : UrlParser(type) {
    companion object {
        private const val CAMPAIGN_NAME_MACROS = "{campaign_id}_{campaign_name_lat}"
        private const val ADGROUP_MACROS = "{gbid}"
        private const val AD_MACROS = "{ad_id}"
        private const val KEYWORDS_MACROS = "{phrase_id}{retargeting_id}_{keyword}{adtarget_name}"
        private const val SITE_MACROS = "{source_type}_{source}"
    }

    override val parameters = listOf(
        Parameter(name = "ios_ifa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),

        Parameter(name = "google_aid", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),

        Parameter(name = "click_id", value = LOGID_MACROS, platform = null, required = true),
        Parameter(
            name = "c", value = CAMPAIGN_NAME_MACROS, platform = null, required = false,
            description = "Название кампании (латиницей)"
        ),
        Parameter(
            name = "adgroup_id", value = ADGROUP_MACROS, platform = null, required = false,
            description = "Идентификатор группы объявлений"
        ),
        Parameter(
            name = "creative_id", value = AD_MACROS, platform = null, required = false,
            description = "Идентификатор объявления"
        ),
        Parameter(
            name = "criteria", value = KEYWORDS_MACROS, platform = null, required = false,
            description = "Ключевое слово или условие ретаргетинга"
        ),
        Parameter(
            name = "site_id", value = SITE_MACROS, platform = null, required = false,
            description = "Сайт сети, где был показ (место показа)"
        )
    )

    override val skadNetworkIntegrated = true
}

@Component
class AppMetricaUrlParser : AppMetricaUrlParserBase(ParserType.TRACKING_URL) {
    override val hostPatterns = listOf(
        """^redirect\.appmetrica\.yandex\.(?:com|ru)$""".toRegex(),
    )

    override val trackingSystem = TrackingSystem.APPMETRICA
    override val trackerIdFetcher = InPathTrackerIdFetcher()
}

@Component
class AppMetricaUniversalTrackingUrlParser : AppMetricaUrlParserBase(ParserType.TRACKING_URL) {
    override val hostPatterns = listOf(
        """^\d+\.redirect\.appmetrica\.yandex\.(?:com|ru)$""".toRegex(),
    )

    override val trackingSystem = TrackingSystem.APPMETRICAUL
    override val trackerIdFetcher = AppMetricaUniversalTrackerIdFetcher()
}

class AppMetricaUniversalTrackerIdFetcher: TrackerIdFetcher {
    override fun getTrackerId(urlParts: UrlParts): String? {
        return urlParts.parameters
            ?.firstOrNull { it.left == "appmetrica_tracking_id" }
            ?.right
    }
}
