package ru.yandex.direct.core.entity.uac.service.trackingurl

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem

@Component
class BranchUrlParser : UrlParser(ParserType.TRACKING_URL) {
    companion object {
        private const val YANDEX_DIRECT_IDENTIFIER = "a_yandex_direct"
    }
    override val hostPatterns = listOf(
        """(^|\.)app.link$""".toRegex(),
    )

    override val trackingSystem = TrackingSystem.BRANCH

    override val parameters = listOf(
        Parameter(name = "%24idfa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),

        Parameter(name = "%24aaid", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),

        Parameter(name = "~click_id", value = LOGID_MACROS, platform = null, required = true),
        Parameter(name = "%243p", value = YANDEX_DIRECT_IDENTIFIER, platform = null, required = true),
    )

    override val skadNetworkIntegrated = false
    override val trackerIdFetcher = InPathTrackerIdFetcher()
}
