package ru.yandex.direct.core.entity.uac.service.trackingurl

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem

@Component
class FlurryUrlParser : UrlParser(ParserType.TRACKING_URL) {
    override val hostPatterns = listOf(
        """(^|\.)ad\.apps\.fm$""".toRegex(),
        """(^|\.)flurry\.com$""".toRegex(),
    )

    override val trackingSystem = TrackingSystem.FLURRY

    override val parameters = listOf(
        Parameter(name = "ios_ifa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),
        Parameter(name = "ios_idfa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),

        Parameter(name = "google_aid", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),
        Parameter(name = "adid", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),

        Parameter(name = "reqid", value = LOGID_MACROS, platform = null, required = true)
    )

    override val trackerIdFetcher = InPathTrackerIdFetcher()
}
