package ru.yandex.direct.core.entity.uac.service.trackingurl

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem
import ru.yandex.direct.utils.model.UrlParts

abstract class MyTrackerBaseUrlParser(type: ParserType) : UrlParser(type) {
    override val hostPatterns = listOf(
        """^trk\.mail\.ru$""".toRegex(),
    )

    override val trackingSystem = TrackingSystem.MY_TRACKER

    override val parameters = listOf(
        Parameter(name = "mt_idfa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),

        Parameter(name = "mt_gaid", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),

        Parameter(name = "clickId", value = LOGID_MACROS, platform = null, required = true),
        Parameter(name = "regid", value = LOGID_MACROS, platform = null, required = true),
    )

    override val externalLink = "https://tracker.my.com"
}

@Component
class MyTrackerTrackingUrlParser : MyTrackerBaseUrlParser(ParserType.TRACKING_URL) {
    override val pathPattern = """^/c/""".toRegex()
    override val hasImpression = true
    override val trackerIdFetcher = InPathTrackerIdFetcher()

    override fun createImpressionUrl(urlParts: UrlParts) = CreateImpressionUrlResult(
        urlParts = urlParts.toBuilder()
            .withPath("/i${urlParts.path.removePrefix("/c")}")
            .build()
    )
}

@Component
class MyTrackerImpressionUrlParser : MyTrackerBaseUrlParser(ParserType.IMPRESSION_URL) {
    override val pathPattern = """^/i/""".toRegex()
    override val trackerIdFetcher = InPathTrackerIdFetcher()
}
