package ru.yandex.direct.core.entity.uac.service.trackingurl

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem

abstract class SingularBaseUrlParser(type: ParserType) : UrlParser(type) {
    override val trackingSystem = TrackingSystem.SINGULAR

    override val parameters = listOf(
        Parameter(name = "idfa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),

        Parameter(name = "aifa", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),
        Parameter(name = "oaid", value = OAID_MACROS, platform = Platform.ANDROID, required = true),

        Parameter(name = "cl", value = LOGID_MACROS, platform = null, required = true),
    )

    override val externalLink = "https://www.singular.net"
}

@Component
class SingularTrackingUrlParser : SingularBaseUrlParser(ParserType.TRACKING_URL) {
    override val hostPatterns = listOf(
        """(^|\.)sng\.link$""".toRegex(),
    )
    override val hasImpression = true
}

@Component
class SingularImpressionUrlParser : SingularBaseUrlParser(ParserType.IMPRESSION_URL) {
    override val hostPatterns = listOf(
        """^i\.sng\.link$""".toRegex(),
    )
}
