package ru.yandex.direct.core.entity.uac.service.trackingurl

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem

@Component
class TuneUrlParser : UrlParser(ParserType.TRACKING_URL) {
    override val hostPatterns = listOf(
        """(^|\.)hastrk[0-9]{1,2}\.com$""",
        """(^|\.)api-[0-9]{1,2}\.com$""",
        """(^|\.)measurementapi\.com$""",
        """(^|\.)tlnk\.io$""",
    ).map { it.toRegex() }

    override val trackingSystem = TrackingSystem.TUNE

    override val parameters = listOf(
        Parameter(name = "ios_ifa", value = IOS_IFA_MACROS, platform = Platform.IOS, required = true),

        Parameter(name = "google_aid", value = GOOGLE_AID_MACROS, platform = Platform.ANDROID, required = true),

        Parameter(name = "publisher_ref_id", value = LOGID_MACROS, platform = null, required = true),
    )

    override val skadNetworkIntegrated = false
}
