package ru.yandex.direct.core.entity.uac.validation

import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams
import ru.yandex.direct.validation.result.Defect

fun maxImageContentSize(
    maxSize: Int,
): Defect<CollectionSizeDefectParams> = Defect(ContentDefectIds.Gen.SIZE_OF_IMAGE_CONTENTS_CANNOT_BE_MORE_THAN_MAX,
    CollectionSizeDefectParams()
        .withMaxSize(maxSize)
)

fun maxVideoContentSize(
    maxSize: Int,
): Defect<CollectionSizeDefectParams> = Defect(ContentDefectIds.Gen.SIZE_OF_VIDEO_CONTENTS_CANNOT_BE_MORE_THAN_MAX,
    CollectionSizeDefectParams()
        .withMaxSize(maxSize)
)

fun canvasDefect(params: CanvasValidationDefectParams): Defect<CanvasValidationDefectParams> {
    return Defect(ContentDefectIds.Canvas.INVALIDATED_BY_CANVAS, params)
}

