package ru.yandex.direct.core.entity.user;

import java.util.Objects;

public class UserLangUtils {
    public static final String INT_UKRAINIAN_LANG_SUBTAG = "ua";
    public static final String EXT_UKRAINIAN_LANG_SUBTAG = "uk";

    private UserLangUtils() {
    }

    public static String intToExt(String lang) {
        return Objects.equals(INT_UKRAINIAN_LANG_SUBTAG, lang) ? EXT_UKRAINIAN_LANG_SUBTAG : lang;
    }

    public static String extToInt(String lang) {
        return Objects.equals(EXT_UKRAINIAN_LANG_SUBTAG, lang) ? INT_UKRAINIAN_LANG_SUBTAG : lang;
    }
}
