package ru.yandex.direct.core.entity.user.model;


import java.time.LocalDateTime;

import javax.annotation.Nullable;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.rbac.RbacRole;


public class ApiUser extends User {

    public static final ModelProperty<ApiUser, ApiEnabled> API_ENABLED =
            ModelProperty.create(ApiUser.class, "apiEnabled", ApiUser::getApiEnabled, ApiUser::setApiEnabled);

    public static final ModelProperty<ApiUser, Boolean> API_GEO_ALLOWED =
            ModelProperty.create(ApiUser.class, "apiGeoAllowed", ApiUser::getApiGeoAllowed, ApiUser::setApiGeoAllowed);

    public static final ModelProperty<ApiUser, Long> API_UNITS_DAILY =
            ModelProperty.create(ApiUser.class, "apiUnitsDaily", ApiUser::getApiUnitsDaily, ApiUser::setApiUnitsDaily);

    public static final ModelProperty<ApiUser, Long> API5_UNITS_DAILY =
            ModelProperty.create(ApiUser.class, "api5UnitsDaily", ApiUser::getApi5UnitsDaily, ApiUser::setApi5UnitsDaily);

    public static final ModelProperty<ApiUser, Long> BRAND_CLIENT_ID =
            ModelProperty.create(ApiUser.class, "brandClientId", ApiUser::getBrandClientId, ApiUser::setBrandClientId);

    public static final ModelProperty<ApiUser, String> API_ALLOWED_IPS =
            ModelProperty.create(ApiUser.class, "apiAllowedIps", ApiUser::getApiAllowedIps, ApiUser::setApiAllowedIps);

    public static final ModelProperty<ApiUser, Long> API_SPECIAL_USER_OPTIONS_CONCURRENT_CALLS =
            ModelProperty.create(ApiUser.class, "concurrentCalls", ApiUser::getConcurrentCalls, ApiUser::setConcurrentCalls);

    public static final ModelProperty<ApiUser, Boolean> API_FINANCIAL_OPERATIONS_ALLOWED =
            ModelProperty.create(ApiUser.class, "apiFinancialOperationsAllowed",
                    ApiUser::getApiFinancialOperationsAllowed, ApiUser::setApiFinancialOperationsAllowed);

    public static final ModelProperty<ApiUser, Boolean> API_OFFER_ACCEPTED =
            ModelProperty.create(ApiUser.class, "apiOfferAccepted",
                    ApiUser::getApiOfferAccepted, ApiUser::setApiOfferAccepted);

    public static final ModelProperty<ApiUser, Boolean> API_SEND_MAIL_NOTIFICATIONS =
            ModelProperty.create(ApiUser.class, "apiSendMailNotifications",
                    ApiUser::getApiSendMailNotifications, ApiUser::setApiSendMailNotifications);

    private ApiEnabled apiEnabled;
    private Boolean apiGeoAllowed;
    private Long apiUnitsDaily;
    private Long api5UnitsDaily;
    private Long brandClientId;
    private Long concurrentCalls;
    private String apiAllowedIps;
    //todo(avzaykov): мб,перенести эти три поля ниже в отдельную модель
    private Boolean apiFinancialOperationsAllowed;
    private Boolean apiOfferAccepted;
    private Boolean apiSendMailNotifications;

    public ApiUser() {
    }

    public UidAndClientId toUidAndClientId() {
        return UidAndClientId.of(getUid(), getClientId());
    }

    public boolean isAgency() {
        return RbacRole.AGENCY.equals(getRole());
    }

    public boolean isClient() {
        return RbacRole.CLIENT.equals(getRole());
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public ApiEnabled getApiEnabled() {
        return apiEnabled;
    }

    public Boolean getApiGeoAllowed() {
        if (apiGeoAllowed == null) {
            return false;
        }
        return apiGeoAllowed;
    }

    @Nullable
    public Long getApiUnitsDaily() {
        return apiUnitsDaily;
    }

    @Nullable
    public Long getApi5UnitsDaily() {
        return api5UnitsDaily;
    }

    @Nullable
    public Long getBrandClientId() {
        return brandClientId;
    }

    @Nullable
    public Long getConcurrentCalls() {
        return concurrentCalls;
    }

    @Nullable
    public String getApiAllowedIps() {
        return apiAllowedIps;
    }

    @Nullable
    public Boolean getApiFinancialOperationsAllowed() {
        return apiFinancialOperationsAllowed;
    }

    @Nullable
    public Boolean getApiSendMailNotifications() {
        return apiSendMailNotifications;
    }

    @Nullable
    public Boolean getApiOfferAccepted() {
        return apiOfferAccepted;
    }

    public void setApiEnabled(ApiEnabled apiEnabled) {
        this.apiEnabled = apiEnabled;
    }

    public void setApiGeoAllowed(Boolean apiGeoAllowed) {
        this.apiGeoAllowed = apiGeoAllowed;
    }

    public void setApiUnitsDaily(Long apiUnitsDaily) {
        this.apiUnitsDaily = apiUnitsDaily;
    }

    public void setApi5UnitsDaily(Long api5UnitsDaily) {
        this.api5UnitsDaily = api5UnitsDaily;
    }

    public void setBrandClientId(Long brandClientId) {
        this.brandClientId = brandClientId;
    }

    public void setConcurrentCalls(Long concurrentCalls) {
        this.concurrentCalls = concurrentCalls;
    }

    public void setApiAllowedIps(String apiAllowedIps) {
        this.apiAllowedIps = apiAllowedIps;
    }

    public void setApiFinancialOperationsAllowed(Boolean apiFinancialOperationsAllowed) {
        this.apiFinancialOperationsAllowed = apiFinancialOperationsAllowed;
    }

    public void setApiOfferAccepted(Boolean apiOfferAccepted) {
        this.apiOfferAccepted = apiOfferAccepted;
    }

    public void setApiSendMailNotifications(Boolean apiSendMailNotifications) {
        this.apiSendMailNotifications = apiSendMailNotifications;
    }

    public ApiUser withApiEnabled(final ApiEnabled apiEnabled) {
        this.apiEnabled = apiEnabled;
        return this;
    }

    public ApiUser withApiGeoAllowed(final Boolean apiGeoAllowed) {
        this.apiGeoAllowed = apiGeoAllowed;
        return this;
    }

    public ApiUser withApiUnitsDaily(final Long apiUnitsDaily) {
        this.apiUnitsDaily = apiUnitsDaily;
        return this;
    }

    public ApiUser withApi5UnitsDaily(final Long api5UnitsDaily) {
        this.api5UnitsDaily = api5UnitsDaily;
        return this;
    }

    public ApiUser withBrandClientId(final Long brandClientId) {
        this.brandClientId = brandClientId;
        return this;
    }

    public ApiUser withConcurrentCalls(final Long concurrentCalls) {
        this.concurrentCalls = concurrentCalls;
        return this;
    }

    public ApiUser withApiAllowedIps(final String apiAllowedIps) {
        this.apiAllowedIps = apiAllowedIps;
        return this;
    }

    public ApiUser withApiFinancialOperationsAllowed(Boolean apiFinancialOperationsAllowed) {
        this.apiFinancialOperationsAllowed = apiFinancialOperationsAllowed;
        return this;
    }

    public ApiUser withApiOfferAccepted(Boolean apiOfferAccepted) {
        this.apiOfferAccepted = apiOfferAccepted;
        return this;
    }

    public ApiUser withApiSendMailNotifications(Boolean apiSendMailNotifications) {
        this.apiSendMailNotifications = apiSendMailNotifications;
        return this;
    }

    @Override
    public ApiUser withUid(final Long uid) {
        this.setUid(uid);
        return this;
    }

    @Override
    public ApiUser withLogin(final String login) {
        this.setLogin(login);
        return this;
    }

    @Override
    public ApiUser withClientId(final ClientId clientId) {
        this.setClientId(clientId);
        return this;
    }

    @Override
    public ApiUser withFio(final String fio) {
        this.setFio(fio);
        return this;
    }

    @Override
    public ApiUser withPhone(final String phone) {
        this.setPhone(phone);
        return this;
    }

    @Override
    public ApiUser withEmail(final String email) {
        this.setEmail(email);
        return this;
    }

    @Override
    public ApiUser withLang(final Language lang) {
        this.setLang(lang);
        return this;
    }

    @Override
    public ApiUser withAllowedIps(final String allowedIps) {
        this.setAllowedIps(allowedIps);
        return this;
    }

    @Override
    public ApiUser withSendNews(final Boolean sendNews) {
        this.setSendNews(sendNews);
        return this;
    }

    @Override
    public ApiUser withSendAccNews(final Boolean sendAccNews) {
        this.setSendAccNews(sendAccNews);
        return this;
    }

    @Override
    public ApiUser withSendWarn(final Boolean sendWarn) {
        this.setSendWarn(sendWarn);
        return this;
    }

    @Override
    public ApiUser withStatusBlocked(final Boolean statusBlocked) {
        this.setStatusBlocked(statusBlocked);
        return this;
    }

    @Override
    public ApiUser withStatusEasy(final Boolean statusEasy) {
        this.setStatusEasy(statusEasy);
        return this;
    }

    @Override
    public ApiUser withStatusArch(final Boolean statusArch) {
        this.setStatusArch(statusArch);
        return this;
    }

    @Override
    public ApiUser withCreateTime(final LocalDateTime createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    @Override
    public ApiUser withPassportKarma(final Long passportKarma) {
        this.setPassportKarma(passportKarma);
        return this;
    }

    @Override
    public ApiUser withRole(final RbacRole role) {
        this.setRole(role);
        return this;
    }

    @Override
    public ApiUser withAutobanned(final Boolean autobanned) {
        setAutobanned(autobanned);
        return this;
    }

    @Override
    public ApiUser withCaptchaFreq(final Long captchaFreq) {
        setCaptchaFreq(captchaFreq);
        return this;
    }

    @Override
    public ApiUser withChiefUid(Long chiefUid) {
        setChiefUid(chiefUid);
        return this;
    }

    @Override
    public ApiUser withAgencyClientId(Long agencyClientId) {
        setAgencyClientId(agencyClientId);
        return this;
    }
}
