package ru.yandex.direct.core.entity.user.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.repository.UserRepository;
import ru.yandex.direct.core.entity.user.service.validation.UpdateUserValidationService;
import ru.yandex.direct.core.entity.user.service.validation.UserValidationService;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

@Component
public class UserUpdateOperationProvider {
    private final UserRepository userRepository;
    private final UpdateUserValidationService updateUserValidationService;
    private final UserValidationService userValidationService;
    private final UserService userService;
    private final ShardHelper shardHelper;

    @Autowired
    public UserUpdateOperationProvider(UserRepository userRepository,
                                       UpdateUserValidationService updateUserValidationService,
                                       UserValidationService userValidationService,
                                       UserService userService,
                                       ShardHelper shardHelper) {
        this.userRepository = userRepository;
        this.updateUserValidationService = updateUserValidationService;
        this.userValidationService = userValidationService;
        this.userService = userService;
        this.shardHelper = shardHelper;
    }

    public UserUpdateOperation get(long operatorUid, List<ModelChanges<User>> modelChanges) {
        return new UserUpdateOperation(Applicability.PARTIAL, userRepository, updateUserValidationService,
                userValidationService,
                userService, shardHelper, modelChanges, operatorUid);
    }
}
