package ru.yandex.direct.core.entity.user.service.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.util.ModelChangesValidationTool;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
public class UpdateUserValidationService {
    private final RbacService rbacService;
    private final ModelChangesValidationTool preValidationTool;

    @Autowired
    public UpdateUserValidationService(RbacService rbacService) {
        this.rbacService = rbacService;
        this.preValidationTool = new ModelChangesValidationTool();
    }

    /**
     * Валидация ModelChanges
     * <p>
     * Проверка дубликатов, корректности id и доступности uid оператору
     */
    public ValidationResult<List<ModelChanges<User>>, Defect> preValidate(long operatorUid,
                                                                          List<ModelChanges<User>> modelChangesList) {
        List<Long> uids = mapList(modelChangesList, ModelChanges::getId);
        Set<Long> visibleUids = new HashSet<>(rbacService.getAccessibleAgencySubclients(operatorUid, uids));
        return preValidationTool.validateModelChangesList(modelChangesList, visibleUids);
    }
}
