package ru.yandex.direct.core.entity.user.service.validation;

import ru.yandex.direct.validation.result.Defect;

public class UserDefects {
    private UserDefects() {
    }

    public static Defect userNotFound() {
        return new Defect<>(UserDefectIds.Gen.USER_NOT_FOUND);
    }

    public static Defect userIsNotRepresentative() {
        return new Defect<>(UserDefectIds.Gen.USER_IS_NOT_REPRESENTATIVE);
    }

    public static Defect userIsBlocked() {
        return new Defect<>(UserDefectIds.Gen.USER_IS_BLOCKED);
    }

    public static Defect userAssociatedWithAnotherClient() {
        return new Defect<>(UserDefectIds.Gen.USER_ASSOCIATED_WITH_ANOTHER_CLIENT);
    }

    public static Defect userHasCardPaymentMethod() {
        return new Defect<>(UserDefectIds.Gen.USER_HAS_CARD_PAYMENT_METHOD);
    }

    public static Defect userHasNotValidName() {
        return new Defect<>(UserDefectIds.Gen.USER_HAS_NOT_VALID_NAME);
    }

    public static Defect userHasNotValidEmail() {
        return new Defect<>(UserDefectIds.Gen.USER_HAS_NOT_VALID_EMAIL);
    }

    public static Defect userHasActiveAutoPay() {
        return new Defect<>(UserDefectIds.Gen.USER_HAS_ACTIVE_AUTOPAY);
    }

    public static Defect balanceUserAssociatedWithAnotherClient() {
        return new Defect<>(UserDefectIds.Gen.BALANCE_USER_ASSOCIATED_WITH_ANOTHER_CLIENT);
    }

    public static Defect chiefDeletionProhibited() {
        return new Defect<>(UserDefectIds.Gen.CHIEF_DELETION_PROHIBITED);
    }

    public static Defect userMustBeManager() {
        return new Defect<>(UserDefectIds.Gen.USER_MUST_BE_MANAGER);
    }

    public static Defect userMustBeManagerInBalance() {
        return new Defect<>(UserDefectIds.Gen.USER_MUST_BE_MANAGER_IN_BALANCE);
    }

    public static Defect userCantBeUnblocked() {
        return new Defect<>(UserDefectIds.Gen.USER_CANT_BE_UNBLOCKED);
    }

    public static Defect userHasNoAvailableCurrencies() {
        return new Defect<>(UserDefectIds.Gen.USER_HAS_NO_AVAILABLE_CURRENCIES);
    }
}
