package ru.yandex.direct.core.entity.user.utils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;

import one.util.streamex.EntryStream;

import ru.yandex.direct.blackbox.client.BlackboxClient;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxPhone;

/**
 * Запрос в blackbox для получения телефона пользователя
 * Имплементирует {@link Callable}, чтобы в API можно было делать параллельные запросы
 */
public class BlackboxGetPhoneQuery implements Callable<Map<PassportUid, Optional<BlackboxPhone>>> {

    private final BlackboxGetPhonesQuery blackboxGetPhonesQuery;

    public BlackboxGetPhoneQuery(BlackboxClient blackboxClient, TvmIntegration tvmIntegration,
                                 EnvironmentType environmentType, List<PassportUid> passportUids) {
        blackboxGetPhonesQuery = new BlackboxGetPhonesQuery(blackboxClient, tvmIntegration, environmentType,
                passportUids);
    }

    @Override
    public Map<PassportUid, Optional<BlackboxPhone>> call() {
        Map<PassportUid, List<BlackboxPhone>> allPhonesByUid = blackboxGetPhonesQuery.call();

        return EntryStream.of(allPhonesByUid)
                .nonNullValues()
                .mapValues(blackboxPhones -> blackboxPhones.stream()
                        .filter(blackboxPhone -> blackboxPhone.getIsDefaultNumber().getOrElse(false))
                        .findFirst())
                .toMap();
    }
}
