package ru.yandex.direct.core.entity.user.utils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.blackbox.client.BlackboxClient;
import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.request.params.PhoneAttributesParameterValue;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxAbstractResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxPhone;
import ru.yandex.misc.ip.IpAddress;

import static com.google.common.base.Preconditions.checkState;

public class BlackboxGetPhonesQuery implements Callable<Map<PassportUid, List<BlackboxPhone>>> {

    private static final List<PhoneAttributesParameterValue> PHONE_ATTRIBUTES =
            List.of(PhoneAttributesParameterValue.MASKED_E164_NUMBER,
                    PhoneAttributesParameterValue.MASKED_FORMATTED_NUMBER,
                    PhoneAttributesParameterValue.IS_DEFAULT_NUMBER,
                    PhoneAttributesParameterValue.IS_COMFIRMED_NUMBER,
                    PhoneAttributesParameterValue.IS_SECURE_NUMBER);

    private final BlackboxClient blackboxClient;
    private final List<PassportUid> passportUids;
    private final TvmIntegration tvmIntegration;
    private final TvmService tvmService;

    public BlackboxGetPhonesQuery(BlackboxClient blackboxClient, TvmIntegration tvmIntegration,
                                  EnvironmentType environmentType, List<PassportUid> passportUids) {
        checkState(blackboxClient != null, "blackboxClient must not be null");
        checkState(CollectionUtils.isNotEmpty(passportUids), "passportUids must not be empty");
        this.blackboxClient = blackboxClient;
        this.passportUids = passportUids;
        this.tvmIntegration = tvmIntegration;
        this.tvmService = environmentType != null && environmentType.isProductionOrPrestable()
                ? TvmService.BLACKBOX_PROD
                : TvmService.BLACKBOX_MIMINO;
    }

    @Override
    public Map<PassportUid, List<BlackboxPhone>> call() {
        String tvmTicket = tvmIntegration.getTicket(tvmService);
        Map<PassportUid, BlackboxAbstractResponse> passportUidToBlackboxResponse = blackboxClient
                .userInfoBulk(getUserAddress(),
                        passportUids,
                        null,
                        Optional.empty(),
                        Optional.empty(),
                        false,
                        Optional.of(PHONE_ATTRIBUTES),
                        tvmTicket);

        return EntryStream.of(passportUidToBlackboxResponse)
                .filterValues(r -> r.getO().isPresent())
                .mapValues(respO -> respO.getO().get())
                .mapValues(BlackboxCorrectResponse::getPhones)
                .mapValues(blackboxPhones -> StreamEx.of(blackboxPhones).toList())
                .toMap();
    }

    IpAddress getUserAddress() {
        return HttpUtil.getRemoteAddressForBlackbox();
    }
}
