package ru.yandex.direct.core.entity.user.utils;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.rbac.RbacRepType;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.rbac.RbacSubrole;

public class UserUtil {
    private UserUtil() {
    }

    /**
     * Вернуть истину, если у оператора одна из переданных ролей
     */
    public static boolean hasOneOfRoles(User user, RbacRole... roles) {
        return user.getRole().anyOf(roles);
    }

    public static boolean isClient(User user) {
        return RbacRole.CLIENT.equals(user.getRole());
    }

    public static boolean isSuper(User user) {
        return RbacRole.SUPER.equals(user.getRole());
    }

    public static boolean isSuperReader(User user) {
        return RbacRole.SUPERREADER.equals(user.getRole());
    }

    public static boolean isDeveloper(User user) {
        return RbacRole.SUPERREADER.equals(user.getRole()) && user.getDeveloper() != null && user.getDeveloper();
    }

    public static boolean isSuperManager(User user) {
        return user.getSuperManager();
    }

    public static boolean isAnyTeamLeader(User user) {
        return RbacSubrole.SUPERTEAMLEADER.equals(user.getSubRole()) ||
                RbacSubrole.TEAMLEADER.equals(user.getSubRole());
    }

    public static boolean isTeamLeader(User user) {
        return RbacRole.MANAGER.equals(user.getRole()) && RbacSubrole.TEAMLEADER.equals(user.getSubRole());
    }

    public static boolean isSuperTeamLeader(User user) {
        return RbacRole.MANAGER.equals(user.getRole()) && RbacSubrole.SUPERTEAMLEADER.equals(user.getSubRole());
    }

    public static boolean isSupport(User user) {
        return RbacRole.SUPPORT.equals(user.getRole());
    }

    public static boolean isLimitedSupport(User user) {
        return RbacRole.LIMITED_SUPPORT.equals(user.getRole());
    }

    public static boolean isManager(User user) {
        return RbacRole.MANAGER.equals(user.getRole());
    }

    public static boolean isAgency(User user) {
        return RbacRole.AGENCY.equals(user.getRole());
    }

    public static boolean isLimitedAgency(User user) {
        return RbacRole.AGENCY.equals(user.getRole()) && user.getRepType() == RbacRepType.LIMITED;
    }

    public static boolean isMediaPlanner(User user) {
        return RbacRole.MEDIA.equals(user.getRole());
    }

    public static boolean isPlacer(User user) {
        return RbacRole.PLACER.equals(user.getRole());
    }

    public static boolean isSuperPlacer(User user) {
        return isPlacer(user) && user.getSubRole() == RbacSubrole.SUPERPLACER;
    }

    public static boolean isInternalAdAdmin(User user) {
        return user.getRole() == RbacRole.INTERNAL_AD_ADMIN;
    }

    public static boolean isInternalAdManager(User user) {
        return user.getRole() == RbacRole.INTERNAL_AD_MANAGER;
    }

    public static boolean isInternalAdRole(User user) {
        return hasOneOfRoles(user,
                RbacRole.INTERNAL_AD_ADMIN, RbacRole.INTERNAL_AD_MANAGER,
                RbacRole.INTERNAL_AD_SUPERREADER);
    }

    public static boolean isChiefRep(User user) {
        return RbacRepType.CHIEF.equals(user.getRepType());
    }
}
