package ru.yandex.direct.core.entity.user.validator;

import java.util.regex.Pattern;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;
import static ru.yandex.direct.validation.constraint.StringConstraints.notContains;

/**
 * Валидатор FirstName и LastName пользователя
 */
@Component
public class FirstLastNameValidator implements DefaultValidator<String> {
    static final Integer MAX_SIZE = 20;

    private static final Pattern INVALID_CHARS_PATTERN = Pattern.compile("[\\[&=<>\\]]+");

    public ValidationResult<String, Defect> apply(String name) {
        return ItemValidationBuilder.<String, Defect>of(name)
                .check(notBlank())
                .check(maxStringLength(MAX_SIZE))
                .check(notContains(INVALID_CHARS_PATTERN), When.isValid())
                .getResult();
    }
}
