package ru.yandex.direct.core.entity.usercampaignsfavorite.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import one.util.streamex.EntryStream;
import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import static java.util.Collections.emptyMap;
import static ru.yandex.direct.dbschema.ppc.tables.UserCampaignsFavorite.USER_CAMPAIGNS_FAVORITE;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Repository
public class UserCampaignsFavoriteRepository {

    public Map<Long, Set<Long>> getUserIdsByCampaignIds(DSLContext dslContext, Collection<Long> campaignIds) {
        if (campaignIds.isEmpty()) {
            return emptyMap();
        }
        Map<Long, List<Long>> campaignIdsToUserIds =
                dslContext.select(USER_CAMPAIGNS_FAVORITE.CID, USER_CAMPAIGNS_FAVORITE.UID)
                        .from(USER_CAMPAIGNS_FAVORITE)
                        .where(USER_CAMPAIGNS_FAVORITE.CID.in(campaignIds))
                        .fetchGroups(USER_CAMPAIGNS_FAVORITE.CID, USER_CAMPAIGNS_FAVORITE.UID);
        return EntryStream.of(campaignIdsToUserIds)
                .mapValues(userIds -> listToSet(userIds, Function.identity()))
                .toMap();
    }

    public Set<Long> getCampaignIdsByUid(DSLContext dslContext, long uid) {
        return dslContext
                .select(USER_CAMPAIGNS_FAVORITE.CID)
                .from(USER_CAMPAIGNS_FAVORITE)
                .where(USER_CAMPAIGNS_FAVORITE.UID.eq(uid))
                .fetchSet(USER_CAMPAIGNS_FAVORITE.CID);
    }
}
