package ru.yandex.direct.core.entity.usersnotifications.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.UsersNotifications.USERS_NOTIFICATIONS;
import static ru.yandex.direct.dbschema.ppc.tables.UsersNotificationsDetails.USERS_NOTIFICATIONS_DETAILS;

@Repository
@ParametersAreNonnullByDefault
public class UsersNotificationsRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public UsersNotificationsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Получить список пользователей, подписанных на событие
     * @param shard — шард
     * @param eventName — название события в формате таблицы users_notifications_details
     * @return список uid
     */
    public List<Long> getSubscribedUsers(int shard, String eventName) {
        return dslContextProvider.ppc(shard)
                .select(USERS_NOTIFICATIONS.UID)
                .from(USERS_NOTIFICATIONS.join(USERS_NOTIFICATIONS_DETAILS)
                        .on(USERS_NOTIFICATIONS.NOTIFICATION_ID.eq(USERS_NOTIFICATIONS_DETAILS.NOTIFICATION_ID)))
                .where(USERS_NOTIFICATIONS_DETAILS.EVENT_TYPE.eq(eventName))
                .fetch(USERS_NOTIFICATIONS.UID);
    }
}
