package ru.yandex.direct.core.entity.userssegments.service.validation;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.AdShowType;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.userssegments.service.validation.UsersSegmentDefects.adGroupTypeNotSupported;
import static ru.yandex.direct.core.entity.userssegments.service.validation.UsersSegmentDefects.goalTypeNotSupportedInAdGroup;

public class UsersSegmentConstraints {

    private static final Set<AdGroupType> SUPPORTED_AD_GROUP_TYPES =
            ImmutableSet.of(AdGroupType.CPM_VIDEO, AdGroupType.CPM_BANNER, AdGroupType.CPM_OUTDOOR,
                    AdGroupType.CPM_INDOOR, AdGroupType.CPM_AUDIO, AdGroupType.BASE);

    private static final Map<AdGroupType, Set<AdShowType>> SUPPORTED_AD_SHOW_TYPES_BY_AD_GROUP_TYPE =
            ImmutableMap.of(
                    AdGroupType.CPM_OUTDOOR, ImmutableSet.of(AdShowType.START),
                    AdGroupType.CPM_INDOOR, ImmutableSet.of(AdShowType.START),
                    AdGroupType.BASE, ImmutableSet.of(AdShowType.START)
            );


    public static Constraint<Long, Defect> adGroupTypeSupported(AdGroupType adGroupType) {
        return adGroupId -> SUPPORTED_AD_GROUP_TYPES.contains(adGroupType)
                ? null
                : adGroupTypeNotSupported();
    }

    public static Constraint<AdShowType, Defect> goalTypeSupportedInAdGroup(AdGroupType adGroupType) {
        return Constraint.fromPredicate(adShowType -> {
                    Set<AdShowType> supportedVideoGoalTypes =
                            SUPPORTED_AD_SHOW_TYPES_BY_AD_GROUP_TYPE.get(adGroupType);
                    return supportedVideoGoalTypes == null || supportedVideoGoalTypes.contains(adShowType);
                },
                goalTypeNotSupportedInAdGroup());
    }
}
