package ru.yandex.direct.core.entity.vcard;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

public interface VcardDefectTranslations extends TranslationBundle {
    VcardDefectTranslations INSTANCE = I18NBundle.implement(VcardDefectTranslations.class);

    @MessageFormatStub("Кампания {0}")
    Translatable campaignNotFound(String campaignId);

    @MessageFormatStub("Запрещено добавлять визитку в заархивированную кампанию {0}")
    Translatable archivedCampaignModification(String campaignId);

    // Phone.CountryCode
    @MessageFormatStub("Не указан код страны в поле Phone")
    Translatable phoneCountryCodeIsNullOrEmpty();

    @MessageFormatStub("Код страны в поле Phone должен начинаться со знака '+'")
    Translatable countryCodeMustStartWithPlus();

    @MessageFormatStub("В поле Phone код страны '{0}' вместе с кодом города '{1}' не может начинаться со знака '+'")
    Translatable countryCodeMustNotStartWithPlus(String countryCode, String cityCode);

    @MessageFormatStub("Код страны в поле Phone должен содержать от 1 до 5 символов, начинаться со знака '+' или '8' и состоять из цифр")
    Translatable invalidCountryCodeFormat();

    // Phone.CityCode
    @MessageFormatStub("Не указан код города в поле Phone")
    Translatable phoneCityCodeIsNullOrEmpty();

    @MessageFormatStub("Код города в поле Phone должен содержать от 1 до 5 символов, быть не равным 0 и состоять только из цифр")
    Translatable invalidPhoneCityCodeFormat();

    // Phone.Number
    @MessageFormatStub("Не указан номер телефона в поле Phone")
    Translatable phoneNumberIsNullOrEmpty();

    @MessageFormatStub("В поле Phone указан неправильный формат номера телефона")
    Translatable invalidPhoneNumberFormat();

    // Phone.Extension
    @MessageFormatStub("Добавочный номер в поле Phone должен содержать от 1 до 6 символов и состоять только из цифр")
    Translatable invalidPhoneExtensionFormat();

    // ContactEmail
    @MessageFormatStub("Значение в поле {0} должно содержать только email-адрес")
    Translatable invalidContactEmailFormat(Path path);

    @TranslationStub("В поле City не указано значение, необходимое для определения станции метро")
    Translatable metroCityIsRequired();

    @TranslationStub("В поле MetroStationId указана станция, не существующая в выбранном городе")
    Translatable invalidMetro();

    // InstantMessenger
    @MessageFormatStub("ICQ UIN в поле MessengerLogin должен содержать от 5 до 10 цифр и состоять из цифр и дефисов")
    Translatable invalidIcqLoginFormat();

    @MessageFormatStub("Имя почтового ящика для Мail.Ru Агента в поле MessengerLogin должно содержать только email-адрес с доменами mail.ru, inbox.ru, bk.ru, list.ru")
    Translatable invalidMailAgentLoginFormat();

    @MessageFormatStub("Jabber-идентификатор в поле MessengerLogin должен содержать только email-адрес")
    Translatable invalidJabberLoginFormat();

    @MessageFormatStub("Skype-имя в поле MessengerLogin должно содержать email-адрес или имя, состоящее из букв, цифр и знаков пунктуации")
    Translatable invalidSkypeOrLoginFormat();

    @MessageFormatStub("Во временном интервале в поле {0} допускается указывать часы от 0 до 23 и минуты от 0 до 59")
    Translatable invalidWorktimeTimeFormat(Path path);

    @MessageFormatStub("Во временном интервале в поле {0} допускается указывать минуты, кратные 15")
    Translatable worktimeMinuteNotDivisibleBy15(Path path);

    @MessageFormatStub("В поле {0} допускается указывать только один временной интервал для одного дня недели")
    Translatable worktimeDaysDuplicated(Path path);

    @MessageFormatStub("Указанная визитка дублирует ранее созданную визитку")
    Translatable vcardIsDuplicated();

    @MessageFormatStub("Указанная визитка используется и не может быть удалена")
    Translatable vcardIsInUse();

    @MessageFormatStub("Визитка {0}")
    Translatable vcardId(String vcardId);

    @MessageFormatStub("Разрешено удалять не более {0} визиток в одном запросе")
    Translatable deleteMaxIdsDetailed(Identity max);
}
