package ru.yandex.direct.core.entity.vcard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class VcardWorktimeUtils {

    private static final Logger logger = LoggerFactory.getLogger(VcardWorktimeUtils.class);

    private VcardWorktimeUtils() {
    }

    public static List<VcardWorktime.DailySchedule> getDailySchedules(@Nullable String worktimeString) {
        VcardWorktime worktime;
        try {
            worktime = VcardWorktime.fromEncodedString(worktimeString);

        } catch (IllegalArgumentException e) {
            logger.error("error in VcardWorktime.fromEncodedString for value {}", worktimeString, e);
            return new ArrayList<>();
        }
        return StreamEx.of(worktime.getDailySchedules()).toList();
    }

    public static List<Map<String, String>> toWebWorktimes(@Nullable String worktimeString) {
        List<VcardWorktime.DailySchedule> schedules = getDailySchedules(worktimeString);
        return mapList(schedules, VcardWorktimeUtils::formatDailyScheduleForWeb);
    }

    private static Map<String, String> formatDailyScheduleForWeb(VcardWorktime.DailySchedule schedule) {
        Map<String, String> dayScheduleAsMap = new HashMap<>();
        dayScheduleAsMap.put("d1", Integer.toString(schedule.getDaySince()));
        dayScheduleAsMap.put("d2", Integer.toString(schedule.getDayTill()));
        dayScheduleAsMap.put("h1", String.format("%02d", schedule.getHourSince()));
        dayScheduleAsMap.put("m1", String.format("%02d", schedule.getMinuteSince()));
        dayScheduleAsMap.put("h2", String.format("%02d", schedule.getHourTill()));
        dayScheduleAsMap.put("m2", String.format("%02d", schedule.getMinuteTill()));
        return dayScheduleAsMap;
    }
}
