package ru.yandex.direct.core.entity.vcard.service;

import ru.yandex.direct.core.entity.vcard.model.PointPrecision;
import ru.yandex.direct.core.entity.vcard.model.PointType;
import ru.yandex.direct.geosearch.model.Kind;
import ru.yandex.direct.geosearch.model.Precision;

public class VcardServiceMappings {

    public static PointPrecision precisionFromGeocoder(Precision precision) {
        if (precision == null || precision == Precision.UNKNOWN) {
            return null;
        }
        try {
            return ru.yandex.direct.core.entity.vcard.model.PointPrecision.valueOf(precision.name());
        } catch (IllegalArgumentException e) {
            throw new IllegalStateException("unexpected geocoder precision: " + precision, e);
        }
    }

    public static PointType pointTypeFromGeocoder(Kind kind) {
        if (kind == null || kind == Kind.UNKNOWN) {
            return null;
        }
        try {
            return PointType.valueOf(kind.name());
        } catch (IllegalArgumentException e) {
            throw new IllegalStateException("unexpected geocoder kind: " + kind, e);
        }
    }
}
