package ru.yandex.direct.core.entity.vcard.service.validation;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.service.accesschecker.AccessDefectPresets;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignAccessDefects;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignSubObjectAccessCheckerFactory;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignAccessType;
import ru.yandex.direct.core.entity.vcard.repository.VcardRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefects.vcardIsInUse;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.unique;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

@Service
public class DeleteVcardValidationService {
    private static final CampaignAccessDefects ACCESS_DEFECTS = AccessDefectPresets.DEFAULT_DEFECTS.toBuilder()
            .withNoRights(objectNotFound())
            .withNotVisible(objectNotFound())
            .withTypeNotAllowable(objectNotFound())
            .withTypeNotSupported(objectNotFound())
            .build();

    private final VcardRepository vcardRepository;
    private final CampaignSubObjectAccessCheckerFactory campaignSubObjectAccessCheckerFactory;

    @Autowired
    public DeleteVcardValidationService(VcardRepository vcardRepository,
                                        CampaignSubObjectAccessCheckerFactory campaignSubObjectAccessCheckerFactory) {
        this.vcardRepository = vcardRepository;
        this.campaignSubObjectAccessCheckerFactory = campaignSubObjectAccessCheckerFactory;
    }

    public ValidationResult<List<Long>, Defect> validate(List<Long> vcardIds,
                                                         long operatorUid, ClientId clientId, long clientUid, int shard) {
        Constraint<Long, Defect> accessConstraint = campaignSubObjectAccessCheckerFactory
                .newVcardChecker(operatorUid, clientId, vcardIds)
                .createValidator(CampaignAccessType.READ_WRITE, ACCESS_DEFECTS)
                .getAccessConstraint();

        Set<Long> unusedVcards = vcardRepository.getUnusedVcards(shard, clientUid, vcardIds);

        return ListValidationBuilder.of(vcardIds, Defect.class)
                .checkEach(unique())
                .checkEach(accessConstraint)
                .checkEach(inSet(unusedVcards), vcardIsInUse(), When.isValid())
                .getResult();
    }
}
