package ru.yandex.direct.core.entity.vcard.service.validation;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan;
import static ru.yandex.direct.validation.constraint.NumberConstraints.notLessThan;

public class PointOnMapValidator implements Validator<PointOnMap, Defect> {

    private static final PointOnMapValidator INSTANCE = new PointOnMapValidator();

    public static final BigDecimal LONGITUDE_MIN = BigDecimal.valueOf(-180);
    public static final BigDecimal LONGITUDE_MAX = BigDecimal.valueOf(180);
    public static final BigDecimal LATITUDE_MIN = BigDecimal.valueOf(-90);
    public static final BigDecimal LATITUDE_MAX = BigDecimal.valueOf(90);

    public static PointOnMapValidator pointIsValid() {
        return INSTANCE;
    }

    @Override
    public ValidationResult<PointOnMap, Defect> apply(PointOnMap pointOnMap) {
        ModelItemValidationBuilder<PointOnMap> vb = ModelItemValidationBuilder.of(pointOnMap);

        vb.item(PointOnMap.X)
                .check(notNull())
                .check(notLessThan(LONGITUDE_MIN))
                .check(notGreaterThan(LONGITUDE_MAX));

        vb.item(PointOnMap.Y)
                .check(notNull())
                .check(notLessThan(LATITUDE_MIN))
                .check(notGreaterThan(LATITUDE_MAX));

        vb.item(PointOnMap.X1)
                .check(notNull())
                .check(notLessThan(LONGITUDE_MIN))
                .check(notGreaterThan(LONGITUDE_MAX));

        vb.item(PointOnMap.Y1)
                .check(notNull())
                .check(notLessThan(LATITUDE_MIN))
                .check(notGreaterThan(LATITUDE_MAX));

        vb.item(PointOnMap.X2)
                .check(notNull())
                .check(notLessThan(LONGITUDE_MIN))
                .check(notGreaterThan(LONGITUDE_MAX));

        vb.item(PointOnMap.Y2)
                .check(notNull())
                .check(notLessThan(LATITUDE_MIN))
                .check(notGreaterThan(LATITUDE_MAX));

        return vb.getResult();
    }
}
