package ru.yandex.direct.core.entity.vcard.service.validation;

import ru.yandex.direct.validation.result.DefectId;

public class VcardDefectIds {

    public enum Gen implements DefectId<Void> {
        /**
         * Данный Vcard уже был сохранен ранее
         */
        VCARD_IS_DUPLICATED,
        /**
         * Данный Vcard используется, поэтому не может быть удален
         */
        VCARD_IS_IN_USE,

        /**
         * В мастере визиток при сохранении по vcard_id не найдены c баннеры с таким vcard_id
         */
        BANNERS_WITH_VCARD_ID_NOT_FOUND,
        /**
         * В мастере визиток в assignVcard у назначаемой визитки есть ошибки валидации
         */
        VCARD_HAS_VALIDATION_ERRORS,
        /**
         * В мастере визиток при сохранении по vcard_id
         * номер кампании из визитки отличается от номера кампании из запроса
         */
        INCONSISTENT_VCARD_CID_AND_CAMPAIGN_ID
    }
}
