package ru.yandex.direct.core.entity.walletparams.repository;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.WalletPaymentTransactions.WALLET_PAYMENT_TRANSACTIONS;

@Repository
public class WalletPaymentTransactionsRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public WalletPaymentTransactionsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Nullable
    public String getLastBalanceStatusCode(int shard, Long walletCid) {
        return dslContextProvider.ppc(shard)
                .select(WALLET_PAYMENT_TRANSACTIONS.BALANCE_STATUS_CODE)
                .from(WALLET_PAYMENT_TRANSACTIONS)
                .where(WALLET_PAYMENT_TRANSACTIONS.WALLET_CID.eq(walletCid))
                .orderBy(WALLET_PAYMENT_TRANSACTIONS.ID.desc())
                .limit(1)
                .fetchOne(WALLET_PAYMENT_TRANSACTIONS.BALANCE_STATUS_CODE);
    }
}
