package ru.yandex.direct.core.entity.warnplace.repository;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.QueryWithoutIndex;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.Warnplace.WARNPLACE;

/**
 * Работа с таблицей warnplace
 */
@ParametersAreNonnullByDefault
@Repository
public class WarnplaceRepository {

    protected final DslContextProvider dslContextProvider;

    @Autowired
    public WarnplaceRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Удаляет записи старше указанного времени из таблицы warnplace
     *
     * @param shard          шард
     * @param borderDateTime {@link LocalDateTime} граничное время
     * @return число удаленных записей
     */
    @QueryWithoutIndex("Выборка по дате, только для jobs")
    public int deleteRecordsOlderThan(int shard, LocalDateTime borderDateTime) {
        return dslContextProvider.ppc(shard)
                .deleteFrom(WARNPLACE)
                .where(WARNPLACE.ADDTIME.lessThan(borderDateTime))
                .execute();
    }

}
