package ru.yandex.direct.core.entity.xiva;

import ru.yandex.direct.core.entity.xiva.model.XivaPushesQueuePushType;

/**
 * Класс со статической информацией о типах пушей.
 * */
public final class XivaPushTypeInfo {

    private XivaPushTypeInfo() { }

    /**
     * Получает ttl в секундах.
     * */
    public static int getTTL(XivaPushesQueuePushType push) {
        switch (push) {
            case TOTAL_SUM_CHANGED:
                return 60;
            case FEED_STATUS_CHANGED:
                return 300;
            default: // FAKE_PUSH
                return 10;
        }
    }
}
