package ru.yandex.direct.core.entity.xlshistory.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.XlsHistory.XLS_HISTORY;

/**
 * Работа с таблицей xls_history (метаданные по загруженным/выгруженным кампаниям через xls)
 */
@ParametersAreNonnullByDefault
@Repository
public class XlsHistoryRepository {

    protected final DslContextProvider dslContextProvider;

    @Autowired
    public XlsHistoryRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Возвращает список Id элементов из таблицы xls_history, LOGDATE которых старше {@param borderDateTime}, с
     * лимитом {@param limit}
     *
     * @param shard          шард
     * @param borderDateTime {@link LocalDateTime} граничное время
     * @param limit          количество строк
     */
    public List<Long> getIdsByLogdateLessThan(int shard, LocalDateTime borderDateTime, int limit) {
        return dslContextProvider.ppc(shard)
                .select(XLS_HISTORY.ID)
                .from(XLS_HISTORY)
                .where(XLS_HISTORY.LOGDATE.lessThan(borderDateTime))
                .limit(limit)
                .fetch(XLS_HISTORY.ID);
    }

    /**
     * Удаляет записи из таблицы xls_history по коллекции из Id
     * {@param xlsHistoriesId}
     *
     * @param shard шард
     * @param ids   коллекция id для удаления
     * @return число удаленных записей
     */
    public int deleteById(int shard, Collection<Long> ids) {
        return dslContextProvider.ppc(shard)
                .deleteFrom(XLS_HISTORY)
                .where(XLS_HISTORY.ID.in(ids))
                .execute();
    }
}
