package ru.yandex.direct.core.entity.yandexoffice;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.YandexOffice;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppcdict.tables.YandexOffices.YANDEX_OFFICES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class YandexOfficesRepository {

    private final DslContextProvider dlsDslContextProvider;

    private final JooqMapperWithSupplier<YandexOffice> mapper = createMapper();

    private static JooqMapperWithSupplier<YandexOffice> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(YandexOffice::new)
                .map(property(YandexOffice.OFFICE_ID, YANDEX_OFFICES.OFFICE_ID))
                .map(property(YandexOffice.OFFICE_NICK, YANDEX_OFFICES.OFFICE_NICK))
                .map(property(YandexOffice.OFFICE_PHONE, YANDEX_OFFICES.OFFICE_PHONE))
                .build();
    }

    @Autowired
    public YandexOfficesRepository(DslContextProvider dlsDslContextProvider) {
        this.dlsDslContextProvider = dlsDslContextProvider;
    }

    public Map<Long, YandexOffice> getOfficesById(Collection<Long> officeIds) {
        if (officeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return dlsDslContextProvider.ppcdict()
                .select(mapper.getFieldsToRead())
                .from(YANDEX_OFFICES)
                .where(YANDEX_OFFICES.OFFICE_ID.in(officeIds))
                .fetchMap(YANDEX_OFFICES.OFFICE_ID, mapper::fromDb);
    }

}
