package ru.yandex.direct.core.grut

import ru.yandex.direct.core.entity.banner.service.DatabaseMode
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.feature.FeatureName

class GrutUtils {
    companion object {
        @JvmStatic
        fun FeatureService.getDatabaseMode( clientId: ClientId) : DatabaseMode {
            return if (this.isEnabledForClientId(clientId, FeatureName.CREATE_BANNERS_IN_GRUT_ONLY)) {
                DatabaseMode.ONLY_GRUT
            } else if (this.isEnabledForClientId(clientId, FeatureName.CREATE_BANNERS_IN_GRUT_AND_MYSQL)) {
                DatabaseMode.MYSQL_AND_GRUT
            } else {
                DatabaseMode.ONLY_MYSQL
            }
        }
    }
}
