package ru.yandex.direct.core.grut.api

import com.google.protobuf.ByteString
import ru.yandex.direct.core.entity.uac.grut.GrutContext
import ru.yandex.grut.object_api.proto.ObjectApiServiceOuterClass
import ru.yandex.grut.objects.proto.client.Schema

/**
 * Api для работы с заявкой(таблица campaign в GRuT)
 */
class BriefGrutApi(grutContext: GrutContext, properties: GrutApiProperties = DefaultGrutApiProperties()) :
    GrutApiBase<Schema.TCampaign>(grutContext, Schema.EObjectType.OT_CAMPAIGN, properties) {
    private val setPaths = listOf("/spec")
    override fun buildIdentity(id: Long): ByteString {
        return Schema.TCampaignMeta.newBuilder().setId(id).build().toByteString()
    }

    override fun parseIdentity(identity: ByteString): Long {
        return Schema.TCampaignMeta.parseFrom(identity).id
    }

    override fun serializeMeta(obj: Schema.TCampaign): ByteString {
        return obj.meta.toByteString()
    }

    override fun serializeSpec(obj: Schema.TCampaign): ByteString {
        return obj.spec.toByteString()
    }

    override fun getMetaId(rawMeta: ByteString): Long {
        return Schema.TCampaign.parseFrom(rawMeta).meta.id
    }

    fun selectBriefs(
        filter: String,
        attributeSelector: List<String> = listOf("/meta", "/spec"),
        index: String? = null,
        limit: Long? = null,
        continuationToken: String? = null,
        allowFullScan: Boolean = false
    ): List<Schema.TCampaign> {
        return selectObjectsAs(filter, attributeSelector, index, limit, continuationToken, allowFullScan, ::transformToBrief)
    }

    fun getBriefs(ids: Collection<Long>): List<Schema.TCampaign> {
        val rawClients = getObjectsByIds(ids)
        return rawClients.filter { it.protobuf.size() > 0 }.map { transformToBrief(it)!! }
    }

    fun getBrief(id: Long): Schema.TCampaign? {
        return getBriefs(listOf(id)).firstOrNull()
    }

    fun getBrief(id: Long, attributeSelector: List<String>): Schema.TCampaign? {
        return getBriefs(listOf(id), attributeSelector).firstOrNull()
    }

    fun getBriefs(ids: Collection<Long>, attributeSelector: List<String>): List<Schema.TCampaign> {
        val rawClients = getObjectsByIds(ids, attributeSelector)
        return rawClients.filter { it.protobuf.size() > 0 }.map { transformToBrief(it)!! }
    }

    fun createBriefs(briefs: Collection<Schema.TCampaign>) = createObjects(briefs)
    fun createOrUpdateBriefs(briefs: Collection<Schema.TCampaign>, setPaths: List<String> = this.setPaths) = createOrUpdateObjects(briefs, setPaths)
    fun createBrief(brief: Schema.TCampaign) = createObject(brief)
    fun createOrUpdateBrief(brief: Schema.TCampaign, setPaths: List<String> = this.setPaths) = createOrUpdateObject(brief, setPaths)

    /**
     * Для обновления заявок, для каждой из которых разные setPath/removePath
     */
    fun updateBriefs(updatedObjects: Collection<UpdatedObject>) {
        updateObjects(updatedObjects)
    }

    /**
     * Обновить заявки целиком
     */
    fun updateBriefsFull(briefs: Collection<Schema.TCampaign>) {
        updateBriefs(briefs, setPaths)
    }


    /**
     * Обновить заявку целиком
     */
    fun updateBriefFull(brief: Schema.TCampaign) {
        updateBriefsFull(listOf(brief))
    }

    fun updateBriefs(briefs: Collection<Schema.TCampaign>, setPaths: List<String>, removePaths: List<String> = listOf()) {
        updateObjects(briefs, setPaths, removePaths)
    }

    fun updateBrief(brief: Schema.TCampaign, setPaths: List<String>, removePaths: List<String> = listOf()) {
        updateBriefs(listOf(brief), setPaths, removePaths)
    }

    private fun transformToBrief(raw: ObjectApiServiceOuterClass.TVersionedPayload?): Schema.TCampaign? {
        if (raw == null) return null
        return Schema.TCampaign.parseFrom(raw.protobuf)
    }
}
