package ru.yandex.direct.core.grut.api

import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcProperty
import ru.yandex.direct.common.db.PpcPropertyNames
import java.time.Duration

interface GrutApiProperties {
    fun getObjectsBatchSize(): Int
    fun createOrUpdateObjectsBatchSize(): Int
    fun deleteObjectsBatchSize(): Int
}

class DefaultGrutApiProperties : GrutApiProperties {
    override fun getObjectsBatchSize(): Int = 1000
    override fun createOrUpdateObjectsBatchSize(): Int = 1000
    override fun deleteObjectsBatchSize(): Int  = 1000
}

class GrutReplicationApiProperties(ppcPropertiesSupport: PpcPropertiesSupport) : GrutApiProperties {
    private val createOrUpdateBatchSizeProperty: PpcProperty<Int> =
        ppcPropertiesSupport.get(PpcPropertyNames.GRUT_REPLICATION_CREATE_OR_UPDATE_BATCH_SIZE, Duration.ofSeconds(20))

    private val getBatchSizeProperty: PpcProperty<Int> =
        ppcPropertiesSupport.get(PpcPropertyNames.GRUT_REPLICATION_GET_BATCH_SIZE, Duration.ofSeconds(20))

    private val deleteBatchSizeProperty: PpcProperty<Int> =
        ppcPropertiesSupport.get(PpcPropertyNames.GRUT_REPLICATION_DELETE_BATCH_SIZE, Duration.ofSeconds(20))

    override fun getObjectsBatchSize(): Int = getBatchSizeProperty.getOrDefault(1000)

    override fun createOrUpdateObjectsBatchSize(): Int = createOrUpdateBatchSizeProperty.getOrDefault(1000)

    override fun deleteObjectsBatchSize(): Int  = deleteBatchSizeProperty.getOrDefault(1000)

}
