package ru.yandex.direct.core.grut.api

import java.time.Duration
import com.google.protobuf.ByteString
import ru.yandex.direct.core.entity.uac.grut.GrutContext
import ru.yandex.direct.core.mysql2grut.repository.MinusPhrase
import ru.yandex.grut.object_api.proto.ObjectApiServiceOuterClass
import ru.yandex.grut.objects.proto.MinusPhrase.TMinusPhraseSpec
import ru.yandex.grut.objects.proto.client.Schema
import ru.yandex.grut.objects.proto.client.Schema.EObjectType
import ru.yandex.grut.objects.proto.client.Schema.TMinusPhraseMeta

class MinusPhraseGrutApi(grutContext: GrutContext, properties: GrutApiProperties)
    : GrutApiBase<MinusPhrase>(grutContext, EObjectType.OT_MINUS_PHRASE, properties) {
    companion object {
        private val UPDATE_TIMEOUT = Duration.ofMinutes(1)
    }

    override fun buildIdentity(id: Long): ByteString {
        return TMinusPhraseMeta.newBuilder().setId(id).build().toByteString()
    }

    override fun parseIdentity(identity: ByteString): Long {
        return TMinusPhraseMeta.parseFrom(identity).id
    }

    override fun serializeMeta(obj: MinusPhrase): ByteString {
        return TMinusPhraseMeta.newBuilder()
            .apply {
                obj.id?.let { id = it }
                clientId = obj.clientId
            }
            .build().toByteString()
    }

    override fun serializeSpec(obj: MinusPhrase): ByteString {
        return TMinusPhraseSpec.newBuilder().apply {
            obj.name?.let { this.name = it }
            this.shared = obj.isLibrary
            addAllPhrases(obj.phrases)
        }
            .build()
            .toByteString()

    }

    override fun getMetaId(rawMeta: ByteString): Long {
        return Schema.TMinusPhrase.parseFrom(rawMeta).meta.id
    }

    fun getMinusPhrase(id: Long): Schema.TMinusPhrase? {
        return getObjectAs(id, ::transformToMinusPhrase)
    }

    fun getMinusPhrases(ids: Collection<Long>): List<Schema.TMinusPhrase> {
        val rawClients = getObjectsByIds(ids)
        return rawClients.filter { it.protobuf.size() > 0 }.map { transformToMinusPhrase(it)!! }
    }

    private val setPaths = listOf("/spec")
    fun createOrUpdateMinusPhrases(minusPhrasesList: List<MinusPhrase>) {
        createOrUpdateObjects(minusPhrasesList, setPaths)
    }

    fun createOrUpdateMinusPhrasesParallel(minusPhrasesList: List<MinusPhrase>) {
        createOrUpdateObjectsParallel(minusPhrasesList, UPDATE_TIMEOUT, setPaths)
    }

    private fun transformToMinusPhrase(raw: ObjectApiServiceOuterClass.TVersionedPayload?): Schema.TMinusPhrase? {
        if (raw == null) return null
        return Schema.TMinusPhrase.parseFrom(raw.protobuf)
    }

}

